/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal.build;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantManager;
import com.aptana.core.internal.build.LazyBuildParticipant;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildParticipantManager
implements IBuildParticipantManager {
    private static final String CONTENT_TYPE_ID = "contentTypeId";
    private static final String CONTENT_TYPE_BINDING = "contentTypeBinding";
    private static final String EXTENSION_ID = "buildParticipants";
    private static final String ELEMENT_PARTICIPANT = "participant";
    private static final String ATTR_CLASS = "class";
    private Map<IConfigurationElement, Set<IContentType>> buildParticipants;

    @Override
    public List<IBuildParticipant> getAllBuildParticipants() {
        HashSet<IBuildParticipant> participants = new HashSet<IBuildParticipant>();
        Map<IConfigurationElement, Set<IContentType>> participantstoContentTypes = this.getBuildParticipants();
        for (Map.Entry<IConfigurationElement, Set<IContentType>> entry : participantstoContentTypes.entrySet()) {
            try {
                IBuildParticipant participant = this.createParticipant(entry.getKey(), entry.getValue());
                if (participant == null) continue;
                participants.add(participant);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Unable to generate instance of build participant: {0}", entry.getKey().getAttribute(ATTR_CLASS)), (Throwable)e);
            }
        }
        ArrayList<IBuildParticipant> result = new ArrayList<IBuildParticipant>(participants);
        Collections.sort(result, new Comparator<IBuildParticipant>(){

            @Override
            public int compare(IBuildParticipant arg0, IBuildParticipant arg1) {
                return arg1.getPriority() - arg0.getPriority();
            }
        });
        return result;
    }

    @Override
    public List<IBuildParticipant> getBuildParticipants(String contentTypeId) {
        HashSet<IBuildParticipant> participants = new HashSet<IBuildParticipant>();
        Map<IConfigurationElement, Set<IContentType>> participantstoContentTypes = this.getBuildParticipants();
        for (Map.Entry<IConfigurationElement, Set<IContentType>> entry : participantstoContentTypes.entrySet()) {
            if (!this.hasType(contentTypeId, entry.getValue())) continue;
            try {
                IBuildParticipant participant = this.createParticipant(entry.getKey(), entry.getValue());
                if (participant == null) continue;
                participants.add(participant);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Unable to generate instance of build participant: {0}", entry.getKey().getAttribute(ATTR_CLASS)), (Throwable)e);
            }
        }
        ArrayList<IBuildParticipant> result = new ArrayList<IBuildParticipant>(participants);
        Collections.sort(result, new Comparator<IBuildParticipant>(){

            @Override
            public int compare(IBuildParticipant arg0, IBuildParticipant arg1) {
                return arg1.getPriority() - arg0.getPriority();
            }
        });
        return result;
    }

    @Override
    public List<IBuildParticipant> filterParticipants(List<? extends IBuildParticipant> participants, final String contentTypeId) {
        return CollectionsUtil.filter(participants, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant item) {
                return BuildParticipantManager.this.hasType(contentTypeId, item.getContentTypes());
            }
        });
    }

    private IBuildParticipant createParticipant(IConfigurationElement ice, Set<IContentType> contentTypes) throws CoreException {
        return new LazyBuildParticipant(ice);
    }

    private boolean hasType(String contentTypeId, Set<IContentType> types) {
        if (CollectionsUtil.isEmpty(types)) {
            return true;
        }
        for (IContentType type : types) {
            if (type == null || !type.getId().equals(contentTypeId)) continue;
            return true;
        }
        return false;
    }

    private synchronized Map<IConfigurationElement, Set<IContentType>> getBuildParticipants() {
        if (this.buildParticipants == null) {
            final HashMap<IConfigurationElement, Set<IContentType>> map = new HashMap<IConfigurationElement, Set<IContentType>>();
            final IContentTypeManager manager = Platform.getContentTypeManager();
            EclipseUtil.processConfigurationElements((String)"com.aptana.buildpath.core", (String)EXTENSION_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    IConfigurationElement[] contentTypes;
                    HashSet<IContentType> types = new HashSet<IContentType>();
                    IConfigurationElement[] iConfigurationElementArray = contentTypes = element.getChildren(BuildParticipantManager.CONTENT_TYPE_BINDING);
                    int n = contentTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement contentTypeBinding = iConfigurationElementArray[n2];
                        String contentTypeId = contentTypeBinding.getAttribute(BuildParticipantManager.CONTENT_TYPE_ID);
                        IContentType type = manager.getContentType(contentTypeId);
                        if (type != null) {
                            types.add(type);
                        }
                        ++n2;
                    }
                    map.put(element, types);
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{BuildParticipantManager.ELEMENT_PARTICIPANT});
                }
            });
            this.buildParticipants = map;
        }
        return this.buildParticipants;
    }

    @Override
    public Set<IContentType> getContentTypes() {
        Map<IConfigurationElement, Set<IContentType>> participants = this.getBuildParticipants();
        HashSet<IContentType> contentTypes = new HashSet<IContentType>();
        for (Set<IContentType> types : participants.values()) {
            contentTypes.addAll(types);
        }
        return Collections.unmodifiableSet(contentTypes);
    }
}

